\ProvidesClass{sprawigoe}[11/01/2022 v.0.2]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ferdinand Kreutzkamp, i.a. Herrn Kracht %
% Sprachwissenschaftliches Seminar        % 
% Universität Göttingen                   % 
% 15.02.2016                              %
%										  %
% modifiziert v. 0.2: 				      %
% Georg Höhn, 11/01/2022				  %
% 										  &
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% changelog
%
% v 0.2:
% - switch to KOMAscript class scrartcl for more flexibility
% - use scrlayer-scrpage for header/footer (instead of older fancyhdr)
% - move choice of gloss packages (linguex, expex) and tree packages (tikz-qtree, forest) to main document
% - setup for XeLaTeX instead of pdfLaTeX (fontspec)


\LoadClassWithOptions{scrartcl}


\RequirePackage{ifthen}

\newboolean{pdflatex}
\setboolean{pdflatex}{false}


\DeclareOption{pdflatex}{
    \setboolean{pdflatex}{true}
}
\ProcessOptions\relax

\ifthenelse{\boolean{pdflatex}}
{ % load if compilation with pdflatex is intended
\RequirePackage[utf8]{inputenc}
\RequirePackage{tipa}
\RequirePackage[T1]{fontenc}
\RequirePackage[ngerman]{babel}
}
{% load 
\RequirePackage{fontspec}
\RequirePackage{polyglossia}
}


\RequirePackage[top = 2.5cm, right = 2.5cm, left = 2.5cm, bottom = 2.5cm, a4paper]{geometry}
\RequirePackage{xcolor}
\RequirePackage{graphicx}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage{hyperref}
\RequirePackage{multirow}
\RequirePackage{multicol}
\RequirePackage{booktabs}
\RequirePackage[backend=biber, style=authoryear, natbib=true]{biblatex}
\RequirePackage{csquotes}
\RequirePackage{tikz}
\RequirePackage{scrlayer-scrpage} %für Kopf- und Fußzeilen
\RequirePackage{setspace}
\RequirePackage{hyphenat}
\RequirePackage{pdfpages}
\RequirePackage{tocloft}
\RequirePackage[toc,page]{appendix}


%Punkte bei Sections im Inhaltsverzeichnis
\renewcommand{\cftsecleader}{\cftdotfill{\cftdotsep}} 

%Literaturverzeichnis
\newcommand{\literatur}[1]{\addbibresource{#1}}
\renewcommand*{\nameyeardelim}{\addcomma\space}
\renewcommand*{\postnotedelim}{\addcolon}
\DeclareFieldFormat{postnote}{#1}
\DeclareFieldFormat{multipostnote}{#1}
\DefineBibliographyStrings{ngerman}{andothers = {{et\,al\adddot}},}


%1,5-Facher Zeilenabstand
\onehalfspacing

%Hurenkinder und Schusterjungen vermeiden
\clubpenalty = 10000
\widowpenalty = 10000
\displaywidowpenalty = 10000


%Tabellen auflockern
\renewcommand{\arraystretch}{1.5}


%%%%%%%%%%%%Deckblatt%%%%%%%%%%%%%%%%%%%%%%%%
%Uni
\def\uni#1{\gdef\@uni{#1}}
\def\@uni{\@latex@warning@no@line{Hey du! An welcher Uni bist du? (\noexpand\uni)}}
%Einrichtung
\def\einrichtung#1{\gdef\@einrichtung{#1}}
\def\@einrichtung{\@latex@warning@no@line{Hey du! Wo studierst du? (\noexpand\einrichtung)}}
%Seminar
\def\seminar#1{\gdef\@seminar{#1}}
\def\@seminar{\@latex@warning@no@line{Hey du! Aus welchem Seminar ist die Arbeit? (\noexpand\seminar)}}
%Dozent
\def\dozent#1{\gdef\@dozent{#1}}
\def\@dozent{\@latex@warning@no@line{Hey du! Kein Dozent? (\noexpand\dozent)}}
%Modul
\def\modul#1{\gdef\@modul{#1}}
\def\@modul{\@latex@warning@no@line{Hey du! Für welches Modul? (\noexpand\modul)}}
%Matrikelnummer
\def\matrikel#1{\gdef\@matrikel{#1}}
\def\@matrikel{\@latex@warning@no@line{Hey du! Was ist deine Matrikelnummer? (\noexpand\matrikel)}}
%Mail
\def\mail#1{\gdef\@mail{#1}}
\def\@mail{\@latex@warning@no@line{Hey du! Wie ist deine Mailadresse? (\noexpand\mail)}}
%Studiengang
\def\studiengang#1{\gdef\@studiengang{#1}}
\def\@studiengang{\@latex@warning@no@line{Hey du! Was studierst du überhaupt? (\noexpand\studiengang)}}
%Abgabedatum
\def\abgabe#1{\gdef\@abgabe{#1}}
\def\@abgabe{\@latex@warning@no@line{Hey du! Wann gibst du denn endlich ab? (\noexpand\abgabe)}}
%Logo1
\def\logo#1{\gdef\@logo{#1}}
%Logo2
\def\logoplus#1{\gdef\@logoplus{#1}}


%\begin{titlepage}

\def\@maketitle{%
\thispagestyle{empty}
\noindent \includegraphics[width= 0.5\textwidth]{\@logo} 
\hfill \includegraphics[width = 0.1\textwidth]{\@logoplus}\\[1cm]
\noindent
\textbf{\@uni}\\
\textbf{Einrichtung:} \@einrichtung \\
\textbf{Dozent:} \@dozent \\
\textbf{Seminar:} \@seminar \\
\textbf{Modulprüfung:} \@modul \\ 
\textbf{Abgabedatum:} \@abgabe
\vfill

\begin{center}
\begin{Large}
\@title
\end{Large}
\end{center}

\vfill
\normalsize\noindent \textbf{Name:} \@author \\
\textbf{Mailadresse:} \texttt{\@mail}\\
\textbf{Studiengang:} \@studiengang \\
\textbf{Matrikelnummer:} \@matrikel  
\thispagestyle{empty}
\newpage
\thispagestyle{empty}
\tableofcontents
\thispagestyle{empty}
\newpage

\setcounter{page}{1}
}%
  
%%%%%%%%%%%%Deckblatt Ende%%%%%%%%%%%%%%%%%%%%%%%%%  


%%%Literaturverzeichnis und Erklärung%%%
\newcommand{\erklaerung}{
\newpage
\addcontentsline{toc}{section}{Literatur}
\printbibliography
\newpage
\section*{Eidesstattliche Erklärung}
Ich versichere hiermit, dass ich die vorliegende wissenschaftliche Arbeit selbständig
verfasst und keine anderen als die angegebenen Hilfsmittel benutzt habe. Sämtliche
Stellen der Arbeit, die dem Wortlaut oder dem Sinn nach anderen Werken
entnommen sind, wurden in jedem Fall durch Quellenangaben (einschließlich des
World Wide Web und anderer elektronischer Text- und Datensammlungen) und nach
den üblichen Regeln wissenschaftlichen Zitierens kenntlich gemacht. Dies gilt auch
für Zeichnungen, Skizzen, bildliche Darstellungen und dergleichen.
Ich bin mir bewusst, dass wahrheitswidrige Angaben als Täuschungsversuch
behandelt werden.
\vspace{.5cm}

\noindent
Göttingen, den \today \\
\vspace{2cm}

\noindent
Unterschrift \@author
}
